import com.xebialabs.restito.semantics.Call;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.semantics.Predicate;
import com.xebialabs.restito.server.StubServer;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;

import java.io.IOException;

import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Condition.custom;
import static com.xebialabs.restito.semantics.Condition.method;

public class PatientClinicalServicesMock extends AbstractMock {

    private final String PATIENT1_ID = "D123401";
    private final String PATIENT10_ID = "0000000008";
    private final String PATIENT14_ID = "0000000014";
    private final String PATIENT51_ID = "0000000003";
    private final String PATIENT66_ID = "0000000001";
    private final String PATIENT_ONE_ID = "P001";

    @Override
    public void run(StubServer server) {

        Predicate<Call> validPatientClinicalServicesRequest = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {
                return input.getUri().matches(".*/VeteranAppointmentRequestService/v4/rest/clinical-services/site/\\d+/patient/EDIPI/.*/patient-clinical-services");
            }
        };

        Function<Response, Response> clinicalServices  = new Function<Response, Response>() {
            @Override
            public Response apply(Response input) {
                String uri = input.getRequest().getRequestURI();
                String siteCodeRegex = ".*/site/(\\d+)/patient";
                String patientIdRegex = ".*/EDIPI/(.*)/patient-clinical-services";

                String siteCode = matchingRegex(uri, siteCodeRegex);
                String patientId = matchingRegex(uri, patientIdRegex);

                Method method = input.getRequest().getMethod();
                String output = createPatientClinicalServices(siteCode, patientId);

                try {
                    input.getWriter().write(output);
                } catch (IOException e) {
                    e.printStackTrace();
                }
                return input;
            }

        };

        whenHttp(server).match(custom(validPatientClinicalServicesRequest), method(Method.GET))
                .then(generateResponse(HttpStatus.OK_200, clinicalServices));
    }

    private String createPatientClinicalServices(String siteCode, String patientId) {
        String template = null;

        switch (patientId) {
            case PATIENT66_ID:
                template = loadTemplate("patient-clinical-services-400-error.json");
                break;
            case PATIENT51_ID:
                template = loadTemplate("patient-clinical-services-tc4.json");
                break;
            case PATIENT14_ID:
                template = loadTemplate("patient-clinical-services-tc4.json");
                break;
            case PATIENT10_ID:
                template = loadTemplate("patient-clinical-services-tc4.json");
                break;
            case PATIENT1_ID:
                template = loadTemplate("patient-clinical-services-tc4-no-pact-team.json");
                break;
            case PATIENT_ONE_ID:
                template = loadTemplate("patient-clinical-services-tc4-yes-pact-team-no-clinic.json");
                break;
            default:
                template = loadTemplate("patient-clinical-services.json");
        }
        return template;
    }
}
